/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.validation;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.ladysnake.blabber.impl.common.model.DialogueChoice;
import org.ladysnake.blabber.impl.common.model.DialogueState;
import org.ladysnake.blabber.impl.common.model.DialogueTemplate;
import org.ladysnake.blabber.impl.common.model.StateType;
import org.ladysnake.blabber.impl.common.validation.ValidationResult;

public final class DialogueValidator {
    public static ValidationResult validateStructure(DialogueTemplate dialogue) {
        HashMap<String, Map> parents = new HashMap<String, Map>();
        ArrayDeque<String> waitList = new ArrayDeque<String>();
        HashMap<String, Reachability> unvalidated = new HashMap<String, Reachability>();
        ArrayList<ValidationResult.Warning> warnings = new ArrayList<ValidationResult.Warning>();
        block9: for (Map.Entry<String, DialogueState> entry : dialogue.states().entrySet()) {
            Iterator<DialogueChoice> iterator;
            if (entry.getValue().type().equals((Object)StateType.END_DIALOGUE)) {
                waitList.add(entry.getKey());
            } else {
                if (dialogue.states().get(entry.getKey()).choices().isEmpty()) {
                    return new ValidationResult.Error.NoChoice(entry.getKey());
                }
                unvalidated.put(entry.getKey(), Reachability.NONE);
                iterator = entry.getValue().choices().iterator();
                while (iterator.hasNext()) {
                    DialogueChoice choice;
                    parents.computeIfAbsent(choice.next(), n -> new HashMap()).put(entry.getKey(), (choice = iterator.next()).condition().isPresent() ? Reachability.CONDITIONAL : Reachability.PROVEN);
                }
            }
            Objects.requireNonNull(DialogueValidator.validateIllustrations(dialogue, entry));
            int choice = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValidationResult.Error.class, ValidationResult.Success.class, ValidationResult.Warnings.class}, (Object)iterator, choice)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ValidationResult.Error error = (ValidationResult.Error)((Object)iterator);
                    return error;
                }
                case 1: {
                    ValidationResult.Success ignored = (ValidationResult.Success)((Object)iterator);
                    continue block9;
                }
                case 2: 
            }
            ValidationResult.Warnings warnings2 = (ValidationResult.Warnings)((Object)iterator);
        }
        while (!waitList.isEmpty()) {
            String state = (String)waitList.pop();
            Map map = (Map)parents.get(state);
            if (map == null) continue;
            block12: for (Map.Entry parent : map.entrySet()) {
                Reachability reachability = (Reachability)((Object)unvalidated.get(parent.getKey()));
                if (reachability == null) continue;
                if (reachability == Reachability.NONE) {
                    waitList.add((String)parent.getKey());
                }
                switch (((Reachability)((Object)parent.getValue())).ordinal()) {
                    case 2: {
                        unvalidated.remove(parent.getKey());
                        continue block12;
                    }
                    case 1: {
                        unvalidated.put((String)parent.getKey(), Reachability.CONDITIONAL);
                        continue block12;
                    }
                }
                throw new IllegalStateException("Unexpected parent-child reachability " + String.valueOf(parent.getValue()));
            }
        }
        for (Map.Entry<String, DialogueState> entry : unvalidated.entrySet()) {
            if (!Objects.equals(entry.getKey(), dialogue.start()) && !parents.containsKey(entry.getKey())) {
                warnings.add(new ValidationResult.Warning.Unreachable(entry.getKey()));
                continue;
            }
            if (entry.getValue() == Reachability.CONDITIONAL) {
                warnings.add(new ValidationResult.Warning.ConditionalSoftLock(entry.getKey()));
                continue;
            }
            return new ValidationResult.Error.SoftLock(entry.getKey());
        }
        return warnings.isEmpty() ? ValidationResult.success() : new ValidationResult.Warnings(warnings);
    }

    private static ValidationResult validateIllustrations(DialogueTemplate dialogue, Map.Entry<String, DialogueState> state) {
        ArrayList<String> illustrations = new ArrayList<String>(state.getValue().illustrations());
        for (DialogueChoice c : state.getValue().choices()) {
            illustrations.addAll(c.illustrations());
        }
        if (!illustrations.isEmpty() && !state.getValue().type().allowsIllustrations()) {
            return new ValidationResult.Error.InvalidIllustratedState(state.getKey(), state.getValue().type(), illustrations);
        }
        for (String illustration : illustrations) {
            if (dialogue.illustrations().containsKey(illustration)) continue;
            return new ValidationResult.Error.NonexistentIllustration(state.getKey(), illustration);
        }
        return ValidationResult.success();
    }

    private static enum Reachability {
        NONE,
        CONDITIONAL,
        PROVEN;

    }
}

